#cs ----------------------------------------------------------------------------

 AutoIt Version:	3.3.2.0
 Author:        	qixx (www.autoit.de)
 Credits:

#ce ----------------------------------------------------------------------------

#Region		### Includes
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#EndRegion	### Includes

Global $Zahl1 = ""
Global $Zahl2 = ""
Global $Operator = ""

;=================================================================================
;
; Function Name:   _CreateCaptcha
; Language:        German
; Description:     Erstellt eine Captcha-Funktion.
; Parameter(s):    $cText  : Control, wo wie Aufgabe angezeigt werden soll
; Requirement(s):  -
; Return Value(s): -
; Author(s):       qixx (www.autoit.de)
;
;=================================================================================
Func _CreateCaptcha($cText)
		$Zahl1 = Random(10,20,1)
		$Zahl2 = Random(1,10,1)
		$Operator = Random(1,2,1)
		If $Operator = 1 Then
			$Operator = " + "
		Else
			$Operator = " - "
		EndIf

		GUICtrlSetData($cText, $Zahl1 & $Operator & $Zahl2 & " =")
EndFunc

;=================================================================================
;
; Function Name:   _NewCaptcha
; Language:        German
; Description:     Erstellt ein neues Captcha
; Parameter(s):    $cText  : Control, wo wie Aufgabe angezeigt werden soll
; Requirement(s):  -
; Return Value(s): -
; Author(s):       qixx (www.autoit.de)
;
;=================================================================================
Func _NewCaptcha($cText)
	_CreateCaptcha($cText)
EndFunc

;=================================================================================
;
; Function Name:   _CheckCaptcha
; Language:        German
; Description::    Prft eine zuvor erstellte Captcha-Funktion auf die Richtigkeit
; Parameter(s):    $cInput  : Control, wo das Ergebnis eingegeben wird
; Requirement(s):  -
; Return Value(s): 0 : Fehler
;				   1 : Erfolg
; Author(s):       qixx (www.autoit.de)
;
;=================================================================================
Func _CheckCaptcha($cInput)
	If $Operator = " + " Then
		If $Zahl1 + $Zahl2 = GUICtrlRead($cInput) Then
			Return 1
		Else
			Return 0
		EndIf
	ElseIf $Operator = " - " Then
		If $Zahl1 - $Zahl2 = GUICtrlRead($cInput) Then
			Return 1
		Else
			Return 0
		EndIf
	Else
		ConsoleWriteError("Scriptfehler! Falscher Operator! (-,+)" & @CRLF)
	EndIf
EndFunc