#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_outfile=sende_email.exe
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Change2CUI=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;Konstanten

Global $anhang_new, $flag, $read_txt, $file, $von, $wichtig, $ssl, $Cmd[15]
Global $oMyRet[2]
Global $oMyError = ObjEvent("AutoIt.Error", "MyErrFunc")

#cs
_InetSmtpMailCom ist ein Script von "Jos" aus dem engl. Forum von AutoIt:
http://www.autoitscript.com/forum/index.php?showtopic=23860&hl=_InetSmtpMailCom
#ce
Func _INetSmtpMailCom($s_FromAddress, $s_ToAddress, $s_SmtpServer, $s_Subject, $as_Body, $s_FromName = "", $s_Username = "", $s_Password = "", $s_AttachFiles = "", $s_CcAddress = "", $s_BccAddress = "", $s_Importance = "Normal", $IPPort = 25, $ssl = 0)
    Local $objEmail = ObjCreate("CDO.Message")
    $objEmail.From = '"' & $s_FromName & '" <' & $s_FromAddress & '>'
    $objEmail.To = $s_ToAddress
    Local $i_Error = 0
    Local $i_Error_desciption = ""
    If $s_CcAddress <> "" Then $objEmail.Cc = $s_CcAddress
    If $s_BccAddress <> "" Then $objEmail.Bcc = $s_BccAddress
    $objEmail.Subject = $s_Subject
    If StringLeft($as_Body,6) =  "<html>" And StringRight($as_Body,7) = "</html>" Then
        $objEmail.HTMLBody = $as_Body
    Else
        $objEmail.Textbody = $as_Body & @CRLF
    EndIf
    If $s_AttachFiles <> "" Then
        Local $S_Files2Attach = StringSplit($s_AttachFiles, ";")
        For $x = 1 To $S_Files2Attach[0]
            $S_Files2Attach[$x] = StringReplace($S_Files2Attach[$x],'"','')
            If FileExists($S_Files2Attach[$x]) Then
                $objEmail.AddAttachment ($S_Files2Attach[$x])
                If @error = 0 Then ConsoleWrite("Datei erfolgreich angehaengt: "&$S_Files2Attach[$x] & @CRLF)
            Else
                ConsoleWrite('!> Dateianhang wurde nicht gefunden: ' & $S_Files2Attach[$x] & @LF)
                SetError(1)
                Return 0
            EndIf
        Next
    EndIf
    $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2
    $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpserver") = $s_SmtpServer
    If Number($IPPort) = 0 then $IPPort = 25
    $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = $IPPort
    ;Authenticated SMTP
    If $s_Username <> "" Then
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendusername") = $s_Username
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/sendpassword") = $s_Password
    EndIf
    If $ssl Then
        $objEmail.Configuration.Fields.Item ("http://schemas.microsoft.com/cdo/configuration/smtpusessl") = True
    EndIf
    ;Update settings
    $objEmail.Configuration.Fields.Update
    ; Set Email Importance
    Switch $s_Importance
        Case "Hoch", "hoch"
            $objEmail.Fields.Item ("urn:schemas:mailheader:Importance") = "High"
        Case "Normal", "normal"
            $objEmail.Fields.Item ("urn:schemas:mailheader:Importance") = "Normal"
        Case "Niedrig", "niedrig"
            $objEmail.Fields.Item ("urn:schemas:mailheader:Importance") = "Low"
    EndSwitch
    $objEmail.Fields.Update
    ; Sent the Message
    $objEmail.Send
    If @error Then
        SetError(2)
        Return $oMyRet[1]
    EndIf
    $objEmail=""
EndFunc   ;==>_INetSmtpMailCom

Func MyErrFunc()
    $HexNumber = Hex($oMyError.number, 8)
    $oMyRet[0] = $HexNumber
    $oMyRet[1] = StringStripWS($oMyError.description, 3)
    mbparam(2)
    ConsoleWrite("### COM Error !  Number: " & $HexNumber & "   ScriptLine: " & $oMyError.scriptline & "   Description:" & $oMyRet[1] & @LF)
    SetError(1); something to check for when this function returns
    Return
EndFunc   ;==>MyErrFunc

Func mbparam($flag = 0)
    Switch $flag
        Case 0
            ConsoleWrite(@CRLF& _
            "Folgende Parameter sind notwendig ([ ] = optional):"& @CRLF& _
            @CRLF & _
            "sende_email.exe 1 2 3 4 5 [6 7 8 9 10 11 12 13 14]"&@CRLF& _
            StringFormat("%-23s %-25s","1  = Absender-Adresse","(Ihre Email-Adresse)")&@CRLF& _
            StringFormat("%-23s %-25s","2  = Empfaenger-Adresse","(Die Empfaenger Email-Adresse)")&@CRLF& _
            StringFormat("%-23s %-25s","3  = Smtp-Server","(Der SMTP-Server Ihres Email-Kontos)")&@CRLF& _
            StringFormat("%-23s %-25s","4  = Betreff","(Der Betreff der Email)")&@CRLF& _
            StringFormat("%-23s %-25s","5  = Nachricht","(HTML-Mail wenn '<html></html>' vorhanden)") &@CRLF& _
            StringFormat("%-23s %-22s","","(es kann auch der Pfad zu einer Datei angegeben werden.)")&@CRLF& _
            "[optional]"&@CRLF& _
            StringFormat("%-23s %-25s","6  = Absender-Name","(Angezeigter Name)")&@CRLF& _
            StringFormat("%-23s %-25s","7  = Anmeldename","(Ihr Zugangsname i.d.R. Ihre Email-Adresse)")&@CRLF& _
            StringFormat("%-23s %-25s","8  = Passwort","(Ihr Zugangspasswort zu Ihrem Email-Konto)")&@CRLF& _
            StringFormat("%-23s %-25s","9  = Dateianhang","(Pfad zu/r Datei/n, die angehaengt werden soll/en)")&@CRLF& _
            StringFormat("%-23s %-25s","10 = Cc-Adresse/n","(CC-Empfaenger dieser Email)")&@CRLF& _
            StringFormat("%-23s %-25s","11 = Bcc-Adresse/n","(BCC-Empfaenger dieser Email)")&@CRLF& _
            StringFormat("%-23s %-25s","12 = Wichtigkeit","(Standard = 'Normal', (Hoch, Niedrig))")&@CRLF& _
            StringFormat("%-23s %-25s","13 = Port","(Standard = 25)")&@CRLF& _
            StringFormat("%-23s %-25s","14 = SSL","(Standard = 0; aktiviert = 1)")&@CRLF& _
            @CRLF& _
            "Die Parameter muessen in der erwarteten Reihenfolge angegeben werden."&@CRLF& _
            "Angaben mit Leerzeichen sind mit "&'" '&'"'&" einzuchliessen."&@CRLF& _
            "mehrere Empfaenger/Dateien sind mit ';' zu trennen"&@CRLF& _
            "eine grafische Oberflaeche zum Versenden Ihrer Email erhalten Sie mit '/gui'"&@CRLF)
        Case 1
            ConsoleWrite(@CRLF&"!!! Bei der Angabe der Parameter ist ein Fehler aufgetreten !!!" &@CRLF& _
            "Geben Sie nach dem Programmnamen den Parameter /? oder /help an, um eine"&@CRLF& _
            "Uebersicht aller notwendigen/optionalen Parameter zu erhalten."&@CRLF)
            SetError(1)
            $flag = 0
        Case 2
            ConsoleWrite(@CRLF&"!!! Bei der Verarbeitung der Parameter ist ein Fehler aufgetreten !!!" &@CRLF& "Es wurden weniger als 14 Parameter uebergeben!!!"&@CRLF& _
            "Geben Sie nach dem Programmnamen den Parameter /? oder /help an, um eine"&@CRLF& _
            "Uebersicht aller notwendigen/optionalen Parameter zu erhalten."&@CRLF)
            SetError(1)
            $flag = 0
        Case 3
            ConsoleWrite(@CRLF&"!!! Bei der Verarbeitung der Parameter ist ein Fehler aufgetreten !!!" &@CRLF& "Es wurden mehr als 14 Parameter uebergeben!!!"&@CRLF& _
            "Geben Sie nach dem Programmnamen den Parameter /? oder /help an, um eine"&@CRLF& _
            "Uebersicht aller notwendigen/optionalen Parameter zu erhalten."&@CRLF)
            SetError(1)
            $flag = 0
    EndSwitch

EndFunc   ;==>mbmparam

Func _PathFull($sRelativePath, $sBasePath = @WorkingDir)
    If Not $sRelativePath Or $sRelativePath = "." Then Return $sBasePath
    Local $sFullPath = StringReplace($sRelativePath, "/", "\") ; Holds the full path (later, minus the root)
    Local Const $sFullPathConst = $sFullPath ; Holds a constant version of the full path.
    Local $sPath ; Holds the root drive/server
    Local $bRootOnly = StringLeft($sFullPath, 1) = "\" And StringMid($sFullPath, 2, 1) <> "\"
    For $i = 1 To 2
        $sPath = StringLeft($sFullPath, 2)
        If $sPath = "\\" Then
            $sFullPath = StringTrimLeft($sFullPath, 2)
            $sPath &= StringLeft($sFullPath, StringInStr($sFullPath, "\") - 1)
            ExitLoop
        ElseIf StringRight($sPath, 1) = ":" Then
            $sFullPath = StringTrimLeft($sFullPath, 2)
            ExitLoop
        Else
            $sFullPath = $sBasePath & "\" & $sFullPath
        EndIf
    Next
    If $i = 3 Then Return ""
    Local $aTemp = StringSplit($sFullPath, "\")
    Local $aPathParts[$aTemp[0]], $j = 0
    For $i = 2 To $aTemp[0]
        If $aTemp[$i] = ".." Then
            If $j Then $j -= 1
        ElseIf Not ($aTemp[$i] = "" And $i <> $aTemp[0]) And $aTemp[$i] <> "." Then
            $aPathParts[$j] = $aTemp[$i]
            $j += 1
        EndIf
    Next
    $sFullPath = $sPath
    If Not $bRootOnly Then
        For $i = 0 To $j - 1
            $sFullPath &= "\" & $aPathParts[$i]
        Next
    Else
        $sFullPath &= $sFullPathConst
        If StringInStr($sFullPath, "..") Then $sFullPath = _PathFull($sFullPath)
    EndIf
    While StringInStr($sFullPath, ".\")
        $sFullPath = StringReplace($sFullPath, ".\", "\")
    WEnd
    Return $sFullPath
EndFunc   ;==>_PathFull